<?php
namespace Core;

class EntityIpCheck {
    private $apiUrl = 'https://entitygate.net/api/checkentity/';

    public function lookup($ip) {
        $url = $this->apiUrl . urlencode($ip);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $response = curl_exec($ch);
        curl_close($ch);
        if ($response === false) {
            return null;
        }
        $data = json_decode($response, true);
        return $data['Entity'] ?? null;
    }

    public function log($message, $entityData, $logFile = null) {
        $logDir = dirname(__DIR__) . '/logs';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0777, true);
        }
        $logFile = $logFile ?? $logDir . '/entity_log.json';
        $logEntry = [
            'message' => $message,
            'timestamp' => date('c'),
            'entity' => $entityData
        ];
        $existing = [];
        if (file_exists($logFile)) {
            $existing = json_decode(file_get_contents($logFile), true) ?? [];
        }
        $existing[] = $logEntry;
        file_put_contents($logFile, json_encode($existing, JSON_PRETTY_PRINT));
    }
}
?>
